/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class LaezelVlaakithsChampionEffect
extends ReplacementEffectImpl {
    LaezelVlaakithsChampionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature, false);
        this.staticText = "if you would put one or more counters on a creature or planeswalker you control or on yourself, put that many plus one of each of those kinds of counters on that permanent or player instead";
    }

    private LaezelVlaakithsChampionEffect(LaezelVlaakithsChampionEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(CardUtil.overflowInc((int)event.getAmount(), (int)1), true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getAmount() <= 0 || !source.isControlledBy(event.getPlayerId())) {
            return false;
        }
        if (source.isControlledBy(event.getTargetId())) {
            return true;
        }
        Permanent permanent = game.getPermanentEntering(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanent(event.getTargetId());
        }
        return permanent != null && (permanent.isCreature(game) || permanent.isPlaneswalker(game)) && permanent.isControlledBy(source.getControllerId());
    }

    public LaezelVlaakithsChampionEffect copy() {
        return new LaezelVlaakithsChampionEffect(this);
    }
}

