/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.l.LagrellaTheMagpieTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class LagrellaTheMagpieEffect
extends OneShotEffect {
    LagrellaTheMagpieEffect() {
        super(Outcome.Exile);
        this.staticText = "exile any number of other target creatures controlled by different players until {this} leaves the battlefield. When an exiled card enters the battlefield under your control this way, put two +1/+1 counters on it";
    }

    private LagrellaTheMagpieEffect(LagrellaTheMagpieEffect effect) {
        super((OneShotEffect)effect);
    }

    public LagrellaTheMagpieEffect copy() {
        return new LagrellaTheMagpieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || source.getSourcePermanentIfItStillExists(game) == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new LagrellaTheMagpieTriggeredAbility((Cards)cards, game), source);
        return true;
    }
}

