/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class LagrellaTheMagpieTarget
extends TargetPermanent {
    private static final FilterPermanent filter = new FilterCreaturePermanent("other creatures controlled by different players");

    LagrellaTheMagpieTarget() {
        super(0, Integer.MAX_VALUE, filter, false);
    }

    private LagrellaTheMagpieTarget(LagrellaTheMagpieTarget target) {
        super((TargetPermanent)target);
    }

    public LagrellaTheMagpieTarget copy() {
        return new LagrellaTheMagpieTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Permanent creature = game.getPermanent(id);
        if (creature == null) {
            return false;
        }
        return this.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).noneMatch(permanent -> !creature.getId().equals(permanent.getId()) && creature.isControlledBy(permanent.getControllerId()));
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

