/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LandsEdgeEffect
extends OneShotEffect {
    LandsEdgeEffect() {
        super(Outcome.Neutral);
        this.staticText = "If the discarded card was a land card, {this} deals 2 damage to target player or planeswalker";
    }

    private LandsEdgeEffect(LandsEdgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            List cards;
            DiscardCardCost cost = (DiscardCardCost)source.getCosts().get(0);
            if (cost != null && (cards = cost.getCards()).size() == 1 && ((Card)cards.get(0)).isLand(game)) {
                DamageTargetEffect effect = new DamageTargetEffect(2);
                effect.setTargetPointer(this.getTargetPointer().copy());
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }

    public LandsEdgeEffect copy() {
        return new LandsEdgeEffect(this);
    }
}

