/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class LanternOfRevealingEffect
extends OneShotEffect {
    LanternOfRevealingEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's a land card, you may put it onto the battlefield tapped. If you don't put the card onto the battlefield, you may put it on the bottom of your library";
    }

    private LanternOfRevealingEffect(LanternOfRevealingEffect effect) {
        super((OneShotEffect)effect);
    }

    public LanternOfRevealingEffect copy() {
        return new LanternOfRevealingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards("Top card of library", card, game);
        if (card.isLand(game) && player.chooseUse(this.outcome, "Put " + card.getName() + " onto the battlefield tapped?", source, game)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        if (game.getState().getZone(card.getId()) == Zone.LIBRARY && player.chooseUse(this.outcome, "Put " + card.getName() + " on the bottom of your library?", source, game)) {
            player.putCardsOnBottomOfLibrary(card, game, source);
        }
        return true;
    }
}

