/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;

class LaquatussCreativityEffect
extends OneShotEffect {
    public LaquatussCreativityEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player draws cards equal to the number of cards in their hand, then discards that many cards.";
    }

    private LaquatussCreativityEffect(LaquatussCreativityEffect effect) {
        super((OneShotEffect)effect);
    }

    public LaquatussCreativityEffect copy() {
        return new LaquatussCreativityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            int handCount = player.getHand().count(new FilterCard(), game);
            player.drawCards(handCount, source, game);
            player.discard(handCount, false, false, source, game);
        }
        return false;
    }
}

