/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.l.LaraCroftTombRaiderWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;

class LaraCroftTombRaiderCastEffect
extends AsThoughEffectImpl {
    LaraCroftTombRaiderCastEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "you may play a card from exile with a discovery counter on it this turn";
    }

    private LaraCroftTombRaiderCastEffect(LaraCroftTombRaiderCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public LaraCroftTombRaiderCastEffect copy() {
        return new LaraCroftTombRaiderCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        LaraCroftTombRaiderWatcher.incrementWatcher(source.getControllerId(), game);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Card card = game.getCard(sourceId);
        return card != null && affectedControllerId.equals(source.getControllerId()) && game.getState().getZone(sourceId) == Zone.EXILED && card.getCounters(game).containsKey(CounterType.DISCOVERY) && LaraCroftTombRaiderWatcher.checkPlayer(source.getControllerId(), game);
    }
}

