/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class LashknifeBarrierEffect
extends ReplacementEffectImpl {
    LashknifeBarrierEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a source would deal damage to a creature you control, it deals that much damage minus 1 to that creature instead.";
    }

    private LashknifeBarrierEffect(LashknifeBarrierEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public LashknifeBarrierEffect copy() {
        return new LashknifeBarrierEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() - 1);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId());
    }
}

