/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class LastDitchEffortEffect
extends OneShotEffect {
    LastDitchEffortEffect() {
        super(Outcome.Damage);
        this.staticText = "Sacrifice any number of creatures. {this} deals that much damage to any target";
    }

    private LastDitchEffortEffect(LastDitchEffortEffect effect) {
        super((OneShotEffect)effect);
    }

    public LastDitchEffortEffect copy() {
        return new LastDitchEffortEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES);
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            int numSacrificed = 0;
            for (UUID permanentId : target.getTargets()) {
                Permanent permanent = game.getPermanent(permanentId);
                if (permanent == null || !permanent.sacrifice(source, game)) continue;
                ++numSacrificed;
            }
            if (numSacrificed > 0) {
                UUID uuid = this.getTargetPointer().getFirst(game, source);
                Permanent permanent = game.getPermanent(uuid);
                Player opponent = game.getPlayer(uuid);
                if (permanent != null) {
                    permanent.damage(numSacrificed, source.getSourceId(), source, game, false, true);
                }
                if (opponent != null) {
                    opponent.damage(numSacrificed, source.getSourceId(), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

