/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardCardYouChooseTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LastRitesEffect
extends OneShotEffect {
    LastRitesEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Discard any number of cards. Target player reveals their hand, then you choose a nonland card from it for each card discarded this way. That player discards those cards";
    }

    private LastRitesEffect(LastRitesEffect effect) {
        super((OneShotEffect)effect);
    }

    public LastRitesEffect copy() {
        return new LastRitesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetPlayer == null) {
            return false;
        }
        int discardCount = controller.discard(0, Integer.MAX_VALUE, false, source, game).size();
        FilterCard filter = new FilterCard((discardCount > 1 ? "" : "a") + " nonland card" + (discardCount > 1 ? "s" : ""));
        filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
        DiscardCardYouChooseTargetEffect effect = new DiscardCardYouChooseTargetEffect((DynamicValue)StaticValue.get((int)discardCount), filter);
        effect.setTargetPointer((TargetPointer)new FixedTarget(targetPlayer.getId()));
        effect.apply(game, source);
        return true;
    }
}

