/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.OutlawPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class LaughingJasperFlintEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent();
    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    LaughingJasperFlintEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top X cards of target opponent's library, where X is the number of outlaws you control. Until end of turn, you may cast spells from among those cards, and mana of any type can be spent to cast those spells";
    }

    private LaughingJasperFlintEffect(LaughingJasperFlintEffect effect) {
        super((OneShotEffect)effect);
    }

    public LaughingJasperFlintEffect copy() {
        return new LaughingJasperFlintEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        int count = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, count));
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)true);
        }
        return true;
    }

    static {
        filter.add((Predicate)OutlawPredicate.instance);
        hint = new ValueHint("Outlaws you control", (DynamicValue)new PermanentsOnBattlefieldCount(filter));
    }
}

