/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LavaBlisterEffect
extends OneShotEffect {
    LavaBlisterEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy target nonbasic land unless its controller has {this} deal 6 damage to them";
    }

    private LavaBlisterEffect(LavaBlisterEffect effect) {
        super((OneShotEffect)effect);
    }

    public LavaBlisterEffect copy() {
        return new LavaBlisterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
            String message = "Have Lava Blister do 6 damage to you?";
            if (player.chooseUse(Outcome.Damage, message, source, game)) {
                player.damage(6, source.getSourceId(), source, game);
            } else {
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

