/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.MageInt;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.dynamicvalue.common.SourcePermanentPowerValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.mana.DynamicManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.common.TargetPlayerOrPlaneswalker;

public final class LeafkinAvenger
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature with power 4 or greater you control");
    private static final DynamicValue xValue;

    public LeafkinAvenger(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{R}{G}");
        this.subtype.add((Object)SubType.ELEMENTAL);
        this.subtype.add((Object)SubType.DRUID);
        this.power = new MageInt(4);
        this.toughness = new MageInt(3);
        this.addAbility(new DynamicManaAbility(Mana.GreenMana((int)1), xValue).addHint((Hint)new ValueHint("Creatures with power 4 or greater you control", xValue)));
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new DamageTargetEffect((DynamicValue)SourcePermanentPowerValue.NOT_NEGATIVE).setText("{this} deals damage equal to its power to target player or planeswalker"), (Cost)new ManaCostsImpl("{7}{R}"));
        ability.addTarget((Target)new TargetPlayerOrPlaneswalker());
        this.addAbility((Ability)ability);
    }

    private LeafkinAvenger(LeafkinAvenger card) {
        super((CardImpl)card);
    }

    public LeafkinAvenger copy() {
        return new LeafkinAvenger(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
        xValue = new PermanentsOnBattlefieldCount(filter);
    }
}

