/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class LearnFromThePastEffect
extends OneShotEffect {
    LearnFromThePastEffect() {
        super(Outcome.Neutral);
        this.staticText = "Target player shuffles their graveyard into their library";
    }

    private LearnFromThePastEffect(LearnFromThePastEffect effect) {
        super((OneShotEffect)effect);
    }

    public LearnFromThePastEffect copy() {
        return new LearnFromThePastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            for (Card card : player.getGraveyard().getCards(game)) {
                player.moveCardToLibraryWithInfo(card, source, game, Zone.GRAVEYARD, true, true);
            }
            player.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

