/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LegionLeadershipTargetEffect
extends OneShotEffect {
    LegionLeadershipTargetEffect() {
        super(Outcome.Benefit);
        this.staticText = "Until end of turn, double target creature's power";
    }

    private LegionLeadershipTargetEffect(LegionLeadershipTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public LegionLeadershipTargetEffect copy() {
        return new LegionLeadershipTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        ContinuousEffect boost = new BoostTargetEffect(permanent.getPower().getValue(), 0, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addEffect(boost, source);
        return true;
    }
}

