/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.l.LegionWarbossAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.GoblinToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LegionWarbossEffect
extends OneShotEffect {
    LegionWarbossEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 red Goblin creature token. That token gains haste until end of turn and attacks this combat if able";
    }

    private LegionWarbossEffect(LegionWarbossEffect effect) {
        super((OneShotEffect)effect);
    }

    public LegionWarbossEffect copy() {
        return new LegionWarbossEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenEffect effect = new CreateTokenEffect((Token)new GoblinToken());
        effect.apply(game, source);
        effect.getLastAddedTokenIds().stream().map(tokenId -> {
            GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
            continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(tokenId, game));
            return continuousEffect;
        }).forEachOrdered(continuousEffect -> game.addEffect(continuousEffect, source));
        effect.getLastAddedTokenIds().stream().map(tokenId -> {
            GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)new LegionWarbossAbility(), Duration.EndOfCombat);
            continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(tokenId, game));
            return continuousEffect;
        }).forEachOrdered(continuousEffect -> game.addEffect(continuousEffect, source));
        return true;
    }
}

