/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LegionsEndEffect
extends OneShotEffect {
    LegionsEndEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target creature an opponent controls with mana value 2 or less and all other creatures that player controls with the same name as that creature. Then that player reveals their hand and exiles all cards with that name from their hand and graveyard.";
    }

    private LegionsEndEffect(LegionsEndEffect effect) {
        super((OneShotEffect)effect);
    }

    public LegionsEndEffect copy() {
        return new LegionsEndEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        String name = permanent.getName();
        if (name == null || name.equals("")) {
            player.revealCards(source, player.getHand(), game);
            return player.moveCards((Card)permanent, Zone.EXILED, source, game);
        }
        CardsImpl cards = new CardsImpl();
        game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game).stream().filter(perm -> name.equals(perm.getName())).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.revealCards(source, player.getHand(), game);
        player.getHand().getCards(game).stream().filter(card -> name.equals(card.getName())).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.getGraveyard().getCards(game).stream().filter(card -> name.equals(card.getName())).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return player.moveCards((Cards)cards, Zone.EXILED, source, game);
    }
}

