/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LesserWerewolfEffect
extends OneShotEffect {
    LesserWerewolfEffect() {
        super(Outcome.Detriment);
        this.staticText = "If {this}'s power is 1 or more, it gets -1/-0 until end of turn and put a -0/-1 counter on target creature blocking or blocked by {this}";
    }

    private LesserWerewolfEffect(LesserWerewolfEffect effect) {
        super((OneShotEffect)effect);
    }

    public LesserWerewolfEffect copy() {
        return new LesserWerewolfEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || sourcePermanent == null || targetPermanent == null) {
            return false;
        }
        if (sourcePermanent.getPower().getValue() >= 1) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(-1, 0, Duration.EndOfTurn), source);
            new AddCountersTargetEffect(CounterType.M0M1.createInstance(), this.outcome).apply(game, source);
        }
        return true;
    }
}

