/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.ControlledModifiedCreatureAsSpellCastWatcher;

class LethalExploitEffect
extends ContinuousEffectImpl {
    private int boostValue = -2;

    public LethalExploitEffect() {
        super(Duration.EndOfTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.UnboostCreature);
        this.staticText = "Target creature gets -2/-2 until end of turn. It gets an additional -1/-1 until end of turn for each modified creature you controlled as you cast this spell";
    }

    private LethalExploitEffect(LethalExploitEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.boostValue = effect.boostValue;
    }

    public LethalExploitEffect copy() {
        return new LethalExploitEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        ControlledModifiedCreatureAsSpellCastWatcher watcher = (ControlledModifiedCreatureAsSpellCastWatcher)game.getState().getWatcher(ControlledModifiedCreatureAsSpellCastWatcher.class);
        MageObject sourceObject = source.getSourceObject(game);
        if (watcher != null && sourceObject != null) {
            this.boostValue -= watcher.getModifiedCreatureCount(new MageObjectReference(sourceObject, game));
        }
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null) {
            return false;
        }
        target.addPower(this.boostValue);
        target.addToughness(this.boostValue);
        return true;
    }
}

