/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ConniveSourceEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class LethalSchemeEffect
extends OneShotEffect {
    LethalSchemeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each creature that convoked this spell connives.";
    }

    private LethalSchemeEffect(LethalSchemeEffect effect) {
        super((OneShotEffect)effect);
    }

    public LethalSchemeEffect copy() {
        return new LethalSchemeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet convokingCreatures = (HashSet)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"convokingCreatures", new HashSet());
        Set<AbstractMap.SimpleEntry> playerPermanentsPairs = convokingCreatures.stream().map(mor -> mor.getPermanentOrLKIBattlefield(game)).filter(Objects::nonNull).map(permanent -> new AbstractMap.SimpleEntry<UUID, Permanent>(permanent.getControllerId(), (Permanent)permanent)).collect(Collectors.toSet());
        HashMap permanentsPerPlayer = new HashMap();
        playerPermanentsPairs.forEach(pair -> {
            Player player = game.getPlayer((UUID)pair.getKey());
            if (!permanentsPerPlayer.containsKey(player)) {
                permanentsPerPlayer.put(player, new HashSet());
            }
            ((Set)permanentsPerPlayer.get(player)).add(pair.getValue());
        });
        if (playerPermanentsPairs.isEmpty()) {
            return false;
        }
        block0: for (Player player : game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).filter(permanentsPerPlayer::containsKey).collect(Collectors.toList())) {
            Set permanents = (Set)permanentsPerPlayer.get(player);
            while (permanents.size() > 0) {
                ChoiceImpl choiceForThisLoop = new ChoiceImpl(true);
                choiceForThisLoop.setMessage("Choose next connive to resolve.");
                permanents.forEach(arg_0 -> LethalSchemeEffect.lambda$apply$3((Choice)choiceForThisLoop, arg_0));
                if (player == null) continue block0;
                player.choose(Outcome.Neutral, (Choice)choiceForThisLoop, game);
                String choice = choiceForThisLoop.getChoice();
                Permanent choicePermanent = permanents.stream().filter(permanent -> permanent.getIdName().equals(choice)).findFirst().orElse(null);
                if (choicePermanent == null) continue block0;
                ConniveSourceEffect.connive((Permanent)choicePermanent, (int)1, (Ability)source, (Game)game);
                permanents.remove(choicePermanent);
            }
        }
        return true;
    }

    private static /* synthetic */ void lambda$apply$3(Choice choiceForThisLoop, Permanent permanent) {
        choiceForThisLoop.getChoices().add(permanent.getIdName());
    }
}

