/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class LeylineOfTheVoidEffect
extends ReplacementEffectImpl {
    LeylineOfTheVoidEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a card would be put into an opponent's graveyard from anywhere, exile it instead";
    }

    private LeylineOfTheVoidEffect(LeylineOfTheVoidEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public LeylineOfTheVoidEffect copy() {
        return new LeylineOfTheVoidEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card;
        return ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && (card = game.getCard(event.getTargetId())) != null && game.getOpponents(source.getControllerId()).contains(card.getOwnerId());
    }
}

