/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class LeylineTyrantManaEffect
extends ContinuousEffectImpl {
    LeylineTyrantManaEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "You don't lose unspent red mana as steps and phases end";
    }

    private LeylineTyrantManaEffect(LeylineTyrantManaEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public LeylineTyrantManaEffect copy() {
        return new LeylineTyrantManaEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.getManaPool().addDoNotEmptyManaType(ManaType.RED);
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

