/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LichsMirrorEffect
extends ReplacementEffectImpl {
    LichsMirrorEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would lose the game, instead shuffle your hand, your graveyard, and all permanents you own into your library, then draw seven cards and your life total becomes 20";
    }

    private LichsMirrorEffect(LichsMirrorEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public LichsMirrorEffect copy() {
        return new LichsMirrorEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null) {
            CardsImpl toLib = new CardsImpl();
            FilterControlledPermanent filter = new FilterControlledPermanent();
            filter.add((Predicate)new OwnerIdPredicate(player.getId()));
            toLib.addAll((Collection)player.getHand());
            toLib.addAll((Collection)player.getGraveyard());
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                toLib.add((Card)permanent);
            }
            player.shuffleCardsToLibrary((Cards)toLib, game, source);
            game.processAction();
            player.drawCards(7, source, game);
            player.setLife(20, game, source);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOSES;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }
}

