/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.GreenManaAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LifeAndLimbEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent("All Forests and all Saprolings");

    LifeAndLimbEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "All Forests and all Saprolings are 1/1 green Saproling creatures and Forest lands in addition to their other types";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
        this.dependendToTypes.add(DependencyType.BecomeForest);
        this.dependendToTypes.add(DependencyType.BecomeIsland);
        this.dependendToTypes.add(DependencyType.BecomeMountain);
        this.dependendToTypes.add(DependencyType.BecomePlains);
        this.dependendToTypes.add(DependencyType.BecomeSwamp);
        this.dependendToTypes.add(DependencyType.BecomeCreature);
    }

    private LifeAndLimbEffect(LifeAndLimbEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public LifeAndLimbEffect copy() {
        return new LifeAndLimbEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                    permanent.addCardType(game, new CardType[]{CardType.LAND});
                    permanent.addSubType(game, new SubType[]{SubType.SAPROLING});
                    permanent.addSubType(game, new SubType[]{SubType.FOREST});
                    if (permanent.getAbilities(game).containsClass(GreenManaAbility.class)) break;
                    permanent.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
                    break;
                }
                case ColorChangingEffects_5: {
                    permanent.getColor(game).setColor(ObjectColor.GREEN);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(1);
                    permanent.getToughness().setModifiedBaseValue(1);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.ColorChangingEffects_5 || layer == Layer.PTChangingEffects_7;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.FOREST.getPredicate(), (Predicate)SubType.SAPROLING.getPredicate()));
    }
}

