/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Optional;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.TargetPermanent;

class LightOfJudgmentEffect
extends OneShotEffect {
    LightOfJudgmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy up to one Equipment attached to that creature";
    }

    private LightOfJudgmentEffect(LightOfJudgmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public LightOfJudgmentEffect copy() {
        return new LightOfJudgmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null || permanent.getAttachments().isEmpty()) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent(SubType.EQUIPMENT, "Equipment attached to " + permanent.getIdName());
        filter.add(Predicates.or((Iterable)permanent.getAttachments().stream().map(PermanentIdPredicate::new).collect(Collectors.toSet())));
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        return Optional.ofNullable(target).map(TargetImpl::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(p -> p.destroy(source, game)).orElse(false);
    }
}

