/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class LightOfSanctionEffect
extends PreventionEffectImpl {
    LightOfSanctionEffect() {
        super(Duration.EndOfGame);
        this.staticText = "Prevent all damage that would be dealt to creatures you control by sources you control.";
        this.consumable = false;
    }

    private LightOfSanctionEffect(LightOfSanctionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId())) {
            MageObject damageSource = game.getObject(event.getSourceId());
            if (damageSource instanceof Controllable) {
                return ((Controllable)damageSource).isControlledBy(source.getControllerId());
            }
            if (damageSource instanceof Card) {
                return ((Card)damageSource).isOwnedBy(source.getControllerId());
            }
        }
        return false;
    }

    public LightOfSanctionEffect copy() {
        return new LightOfSanctionEffect(this);
    }
}

