/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.l.LightmineFieldEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class LightmineFieldTriggeredAbility
extends TriggeredAbilityImpl {
    LightmineFieldTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LightmineFieldEffect());
        this.setTriggerPhrase("Whenever one or more creatures attack, ");
    }

    private LightmineFieldTriggeredAbility(LightmineFieldTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LightmineFieldTriggeredAbility copy() {
        return new LightmineFieldTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        HashSet<MageObjectReference> attackSet = new HashSet<MageObjectReference>();
        for (UUID attackerId : game.getCombat().getAttackers()) {
            Permanent attacker = game.getPermanent(attackerId);
            if (attacker == null) continue;
            attackSet.add(new MageObjectReference((MageObject)attacker, game));
        }
        for (Effect effect : this.getEffects()) {
            effect.setValue("Lightmine Field", attackSet);
        }
        return !attackSet.isEmpty();
    }
}

