/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LightstallInquisitorAsThoughEffect
extends AsThoughEffectImpl {
    private final UUID playerId;
    private final MageObjectReference cardMOR;

    LightstallInquisitorAsThoughEffect(UUID playerId, MageObjectReference cardMOR) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.playerId = playerId;
        this.cardMOR = cardMOR;
    }

    private LightstallInquisitorAsThoughEffect(LightstallInquisitorAsThoughEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.playerId = effect.playerId;
        this.cardMOR = effect.cardMOR;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public LightstallInquisitorAsThoughEffect copy() {
        return new LightstallInquisitorAsThoughEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card = this.cardMOR.getCard(game);
        if (card == null) {
            this.discard();
            return false;
        }
        if (!this.cardMOR.refersTo(objectId, game) || !this.playerId.equals(affectedControllerId)) {
            return false;
        }
        Player player = game.getPlayer(affectedControllerId);
        if (player == null) {
            return false;
        }
        if (card.getSpellAbility() != null) {
            ManaCostsImpl newManaCosts = new ManaCostsImpl();
            newManaCosts.addAll((Collection)card.getManaCost());
            newManaCosts.add((Object)new GenericManaCost(1));
            player.setCastSourceIdWithAlternateMana(card.getId(), (ManaCosts)newManaCosts, card.getSpellAbility().getCosts(), MageIdentifier.LightstallInquisitorAlternateCast);
        }
        return true;
    }
}

