/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.keyword.PlotAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;

class LilahUndefeatedSlickshotEffect
extends ReplacementEffectImpl {
    private final MageObjectReference mor;

    LilahUndefeatedSlickshotEffect(MageObjectReference mor) {
        super(Duration.WhileOnStack, Outcome.Benefit);
        this.mor = mor;
    }

    private LilahUndefeatedSlickshotEffect(LilahUndefeatedSlickshotEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.mor = effect.mor;
    }

    public LilahUndefeatedSlickshotEffect copy() {
        return new LilahUndefeatedSlickshotEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Spell sourceSpell = game.getStack().getSpell(event.getTargetId());
        if (sourceSpell == null || sourceSpell.isCopy()) {
            return false;
        }
        PlotAbility.doExileAndPlotCard((Card)sourceSpell, (Game)game, (Ability)source);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() != Zone.STACK || zEvent.getToZone() != Zone.GRAVEYARD || event.getSourceId() == null || !event.getSourceId().equals(event.getTargetId()) || this.mor.getZoneChangeCounter() != game.getState().getZoneChangeCounter(event.getSourceId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(this.mor.getSourceId());
        return spell != null && spell.isInstantOrSorcery(game);
    }
}

