/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class LilianaOfTheVeilEffect
extends OneShotEffect {
    public LilianaOfTheVeilEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Separate all permanents target player controls into two piles. That player sacrifices all permanents in the pile of their choice";
    }

    private LilianaOfTheVeilEffect(LilianaOfTheVeilEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianaOfTheVeilEffect copy() {
        return new LilianaOfTheVeilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (player != null && targetPlayer != null) {
            int count = game.getBattlefield().countAll(new FilterPermanent(), targetPlayer.getId(), game);
            FilterPermanent filter = new FilterPermanent("permanents to put in the first pile");
            filter.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
            TargetPermanent target = new TargetPermanent(0, count, filter, true);
            ArrayList<Permanent> pile1 = new ArrayList<Permanent>();
            if (player.choose(Outcome.Neutral, (Target)target, source, game)) {
                List targets = target.getTargets();
                for (UUID targetId : targets) {
                    Permanent p = game.getPermanent(targetId);
                    if (p == null) continue;
                    pile1.add(p);
                }
            }
            ArrayList<Permanent> pile2 = new ArrayList<Permanent>();
            for (Permanent p : game.getBattlefield().getAllActivePermanents(targetPlayer.getId())) {
                if (pile1.contains(p)) continue;
                pile2.add(p);
            }
            boolean choice = targetPlayer.choosePile(Outcome.DestroyPermanent, "Choose a pile to sacrifice.", pile1, pile2, game);
            if (choice) {
                this.sacrificePermanents(pile1, game, source);
            } else {
                this.sacrificePermanents(pile2, game, source);
            }
            return true;
        }
        return false;
    }

    private void sacrificePermanents(List<Permanent> pile, Game game, Ability source) {
        for (Permanent permanent : pile) {
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
    }
}

