/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class LilianasScroungerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPlaneswalkerPermanent(SubType.LILIANA, "Liliana planeswalker you control");

    LilianasScroungerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a loyalty counter on a Liliana planeswalker you control";
    }

    private LilianasScroungerEffect(LilianasScroungerEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianasScroungerEffect copy() {
        return new LilianasScroungerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || game.getBattlefield().count(filter, source.getControllerId(), source, game) < 1 || !player.chooseUse(this.outcome, "Put a loyalty counter on a Liliana planeswalker you control?", source, game)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.addCounters(CounterType.LOYALTY.createInstance(), source.getControllerId(), source, game);
    }
}

