/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class LilianasTalentEffect
extends OneShotEffect {
    LilianasTalentEffect() {
        super(Outcome.Benefit);
        this.staticText = "put all creature cards from all graveyards onto the battlefield under your control";
    }

    private LilianasTalentEffect(LilianasTalentEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianasTalentEffect copy() {
        return new LilianasTalentEffect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) return false;
        if (!player.moveCards(game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getGraveyard).map(gy -> gy.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game)).flatMap(Collection::stream).collect(Collectors.toSet()), Zone.BATTLEFIELD, source, game)) return false;
        return true;
    }
}

