/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LilyBowenRagingGrandmaEffect
extends OneShotEffect {
    LilyBowenRagingGrandmaEffect() {
        super(Outcome.Benefit);
    }

    private LilyBowenRagingGrandmaEffect(LilyBowenRagingGrandmaEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        int countBefore = permanent.getCounters(game).getCount(CounterType.P1P1);
        if (countBefore <= 1) {
            return true;
        }
        int countToRemove = countBefore - 1;
        permanent.removeCounters(CounterType.P1P1.createInstance(countToRemove), source, game);
        int countAfter = permanent.getCounters(game).getCount(CounterType.P1P1);
        int countersRemoved = Math.max(0, countBefore - countAfter);
        if (countersRemoved > 0) {
            new GainLifeEffect(countersRemoved).apply(game, source);
        }
        return true;
    }

    public LilyBowenRagingGrandmaEffect copy() {
        return new LilyBowenRagingGrandmaEffect(this);
    }
}

