/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LingeringDeathAbility
extends TriggeredAbilityImpl {
    public LingeringDeathAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SacrificeTargetEffect());
    }

    private LingeringDeathAbility(LingeringDeathAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LingeringDeathAbility copy() {
        return new LingeringDeathAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_TURN_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantedCreature;
        Permanent enchantment = game.getPermanentOrLKIBattlefield(this.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && (enchantedCreature = game.getPermanent(enchantment.getAttachedTo())) != null && event.getPlayerId().equals(enchantedCreature.getControllerId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(enchantment.getAttachedTo(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "At the beginning of the end step of enchanted creature's controller, that player sacrifices that creature.";
    }
}

