/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.l.LiquidFireAdditionalCost;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class LiquidFire
extends CardImpl {
    public LiquidFire(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{4}{R}{R}");
        this.getSpellAbility().addCost((Cost)new LiquidFireAdditionalCost());
        GetXValue choiceValue = GetXValue.instance;
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addEffect((Effect)new LiquidFireEffect((DynamicValue)choiceValue));
    }

    private LiquidFire(LiquidFire card) {
        super((CardImpl)card);
    }

    public LiquidFire copy() {
        return new LiquidFire(this);
    }

    private static class LiquidFireEffect
    extends OneShotEffect {
        protected DynamicValue choiceValue;

        LiquidFireEffect(DynamicValue choiceValue) {
            super(Outcome.Damage);
            this.staticText = "{this} deals X damage to target creature and 5 minus X damage to that creature's controller, where X is the chosen number.";
            this.choiceValue = choiceValue;
        }

        private LiquidFireEffect(LiquidFireEffect effect) {
            super((OneShotEffect)effect);
            this.choiceValue = effect.choiceValue;
        }

        public boolean apply(Game game, Ability source) {
            Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            int creatureDamage = this.choiceValue.calculate(game, source, (Effect)this);
            int playerDamage = 5 - creatureDamage;
            if (target != null) {
                target.damage(creatureDamage, source.getSourceId(), source, game);
                Player controller = game.getPlayer(target.getControllerId());
                if (controller != null) {
                    controller.damage(playerDamage, source.getSourceId(), source, game);
                }
                return true;
            }
            return false;
        }

        public LiquidFireEffect copy() {
            return new LiquidFireEffect(this);
        }
    }
}

