/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class LivingLoreExileEffect
extends OneShotEffect {
    LivingLoreExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile an instant or sorcery card from your graveyard";
    }

    private LivingLoreExileEffect(LivingLoreExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public LivingLoreExileEffect copy() {
        return new LivingLoreExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY_FROM_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        MageObject mageObject = game.getObject(source.getSourceId());
        if (mageObject == null) {
            return false;
        }
        controller.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (UUID)mageObject.getId(), (int)(mageObject.getZoneChangeCounter(game) + 1)), CardUtil.getSourceName((Game)game, (Ability)source));
        return true;
    }
}

