/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LivioOathswornSentinelExileEffect
extends OneShotEffect {
    LivioOathswornSentinelExileEffect() {
        super(Outcome.Exile);
        this.staticText = "choose another target creature. Its controller may exile it with an aegis counter on it";
    }

    private LivioOathswornSentinelExileEffect(LivioOathswornSentinelExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public LivioOathswornSentinelExileEffect copy() {
        return new LivioOathswornSentinelExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null || !player.chooseUse(this.outcome, "Exile " + permanent.getName() + " with an aegis counter on it?", source, game)) {
            return false;
        }
        Card card = game.getCard(permanent.getId());
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        if (card == null || game.getState().getZone(card.getId()) != Zone.EXILED) {
            return false;
        }
        card.addCounters(CounterType.AEGIS.createInstance(), source.getControllerId(), source, game);
        return true;
    }
}

