/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class LlanowarEmpathEffect
extends OneShotEffect {
    LlanowarEmpathEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then reveal the top card of your library. If it's a creature card, put it into your hand.";
    }

    private LlanowarEmpathEffect(LlanowarEmpathEffect effect) {
        super((OneShotEffect)effect);
    }

    public LlanowarEmpathEffect copy() {
        return new LlanowarEmpathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || sourceObject == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null) {
            CardsImpl cards = new CardsImpl();
            cards.add(card);
            controller.revealCards(sourceObject.getName(), (Cards)cards, game);
            if (card.isCreature(game)) {
                controller.moveCards(card, Zone.HAND, source, game);
            }
        }
        return true;
    }
}

