/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventCombatDamageBySourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LoafingGiantEffect
extends OneShotEffect {
    LoafingGiantEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Mill a card. If a land card was milled this way, prevent all combat damage {this} would deal this turn.";
    }

    private LoafingGiantEffect(LoafingGiantEffect effect) {
        super((OneShotEffect)effect);
    }

    public LoafingGiantEffect copy() {
        return new LoafingGiantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && player.millCards(1, source, game).getCards(game).stream().filter(Objects::nonNull).anyMatch(card -> card.isLand(game))) {
            game.addEffect((ContinuousEffect)new PreventCombatDamageBySourceEffect(Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }
}

