/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.l.LobeliaDefenderOfBagLookEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class LobeliaDefenderOfBagEndETBEffect
extends OneShotEffect {
    LobeliaDefenderOfBagEndETBEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of each opponent's library and exile those cards face down";
    }

    private LobeliaDefenderOfBagEndETBEffect(LobeliaDefenderOfBagEndETBEffect effect) {
        super((OneShotEffect)effect);
    }

    public LobeliaDefenderOfBagEndETBEffect copy() {
        return new LobeliaDefenderOfBagEndETBEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl topCards = new CardsImpl();
        for (UUID playerId : game.getOpponents(controller.getId())) {
            Card card;
            Player player = game.getPlayer(playerId);
            if (player == null || (card = player.getLibrary().getFromTop(game)) == null) continue;
            card.setFaceDown(true, game);
            topCards.add(card);
        }
        controller.lookAtCards(source, null, (Cards)topCards, game);
        Set cardSet = topCards.getCards(game);
        if (controller.moveCardsToExile(cardSet, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source))) {
            topCards.retainZone(Zone.EXILED, game);
            topCards.getCards(game).forEach(c -> c.setFaceDown(true, game));
            for (Card card : cardSet) {
                LobeliaDefenderOfBagLookEffect effect = new LobeliaDefenderOfBagLookEffect(controller.getId());
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return true;
    }
}

