/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class LobeliaDefenderOfBagEndWatcher
extends Watcher {
    private final Map<MageObjectReference, Map<UUID, Integer>> morMap = new HashMap<MageObjectReference, Map<UUID, Integer>>();

    LobeliaDefenderOfBagEndWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.PLAY_LAND) {
            if (event.getApprovingObject() == null) {
                return;
            }
            this.morMap.computeIfAbsent(event.getApprovingObject().getApprovingMageObjectReference(), m -> new HashMap()).compute(event.getPlayerId(), (u, i) -> i == null ? 0 : Integer.sum(i, -1));
        }
    }

    public void reset() {
        this.morMap.clear();
        super.reset();
    }

    static boolean checkPermission(UUID playerId, Ability source, Game game) {
        if (!playerId.equals(source.getControllerId())) {
            return false;
        }
        MageObjectReference mor = new MageObjectReference(source);
        LobeliaDefenderOfBagEndWatcher watcher = (LobeliaDefenderOfBagEndWatcher)game.getState().getWatcher(LobeliaDefenderOfBagEndWatcher.class);
        return watcher.morMap.containsKey(mor) && watcher.morMap.get(mor).getOrDefault(playerId, 0) > 0;
    }

    static void addPlayable(Ability source, Game game) {
        MageObjectReference mor = new MageObjectReference(source);
        ((LobeliaDefenderOfBagEndWatcher)game.getState().getWatcher(LobeliaDefenderOfBagEndWatcher.class)).morMap.computeIfAbsent(mor, m -> new HashMap()).compute(source.getControllerId(), CardUtil::setOrIncrementValue);
    }
}

