/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.l.LockeTreasureHunterWatcher;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class LockeTreasureHunterEffect
extends OneShotEffect {
    LockeTreasureHunterEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player mills a card. If a land card was milled this way, create a Treasure token. Until end of turn, you may cast a spell from among those cards";
    }

    private LockeTreasureHunterEffect(LockeTreasureHunterEffect effect) {
        super((OneShotEffect)effect);
    }

    public LockeTreasureHunterEffect copy() {
        return new LockeTreasureHunterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.addAllCards((Collection)player.millCards(1, source, game).getCards(game));
        }
        if (cards.isEmpty()) {
            return false;
        }
        if (cards.count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) > 0) {
            new TreasureToken().putOntoBattlefield(1, game, source);
        }
        LockeTreasureHunterWatcher.saveCards((Cards)cards, game, source);
        return true;
    }
}

