/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class LocketOfYesterdaysCostReductionEffect
extends CostModificationEffectImpl {
    LocketOfYesterdaysCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Spells you cast cost {1} less to cast for each card with the same name as that spell in your graveyard";
    }

    private LocketOfYesterdaysCostReductionEffect(LocketOfYesterdaysCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        MageObject sourceObject = game.getObject(abilityToModify.getSourceId());
        if (sourceObject != null) {
            int amount = 0;
            for (UUID cardId : game.getPlayer(source.getControllerId()).getGraveyard()) {
                Card card = game.getCard(cardId);
                if (card == null || !card.getName().equals(sourceObject.getName())) continue;
                ++amount;
            }
            if (amount > 0) {
                SpellAbility spellAbility = (SpellAbility)abilityToModify;
                CardUtil.adjustCost((SpellAbility)spellAbility, (int)amount);
            }
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.isControlledBy(source.getControllerId()) && abilityToModify instanceof SpellAbility;
    }

    public LocketOfYesterdaysCostReductionEffect copy() {
        return new LocketOfYesterdaysCostReductionEffect(this);
    }
}

