/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class LocusOfEnlightenmentEffect
extends ContinuousEffectImpl {
    LocusOfEnlightenmentEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.staticText = "{this} has each activated ability of the exiled cards used to craft it. You may activate each of those abilities only once each turn";
    }

    private LocusOfEnlightenmentEffect(LocusOfEnlightenmentEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public LocusOfEnlightenmentEffect copy() {
        return new LocusOfEnlightenmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)permanent.getId(), (int)(permanent.getZoneChangeCounter(game) - 2)));
        if (exileZone == null) {
            return false;
        }
        for (Card card : exileZone.getCards(game)) {
            for (Ability ability : card.getAbilities(game)) {
                if (!ability.isActivatedAbility()) continue;
                ActivatedAbility copyAbility = (ActivatedAbility)ability.copy();
                copyAbility.setMaxActivationsPerTurn(1);
                permanent.addAbility((Ability)copyAbility, source.getSourceId(), game, true);
            }
        }
        return true;
    }
}

