/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class LongRestEffect
extends OneShotEffect {
    LongRestEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return X target cards with different mana values from your graveyard to your hand. If eight or more cards were returned to your hand this way, your life total becomes equal to your starting life total";
    }

    private LongRestEffect(LongRestEffect effect) {
        super((OneShotEffect)effect);
    }

    public LongRestEffect copy() {
        return new LongRestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet<Card> cardsToHand = new HashSet<Card>();
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Card card = game.getCard(targetId);
                if (card == null || game.getState().getZone(targetId) != Zone.GRAVEYARD) continue;
                cardsToHand.add(card);
            }
            int numCards = cardsToHand.size();
            if (numCards > 0) {
                controller.moveCards(cardsToHand, Zone.HAND, source, game);
                if (numCards >= 8) {
                    controller.setLife(game.getStartingLife(), game, source);
                }
                return true;
            }
        }
        return false;
    }
}

