/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObjectReference;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileThenReturnTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagedBatchBySourceEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LongRiverLurkerTriggeredAbility
extends DelayedTriggeredAbility
implements BatchTriggeredAbility<DamagedEvent> {
    private final MageObjectReference mor;

    LongRiverLurkerTriggeredAbility(MageObjectReference mor) {
        super((Effect)new ExileThenReturnTargetEffect(false, false).setTargetPointer((TargetPointer)new FixedTarget(mor)), Duration.EndOfTurn, false, true);
        this.mor = mor;
    }

    private LongRiverLurkerTriggeredAbility(LongRiverLurkerTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
    }

    public LongRiverLurkerTriggeredAbility copy() {
        return new LongRiverLurkerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_BY_SOURCE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return ((DamagedBatchBySourceEvent)event).isCombatDamage() && this.mor.refersTo(event.getSourceId(), game);
    }

    public String getRule() {
        return "Whenever that creature deals combat damage this turn, you may exile it. If you do, return it to the battlefield under its owner's control.";
    }
}

