/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LorcanWarlockCollectorReturnEffect
extends OneShotEffect {
    LorcanWarlockCollectorReturnEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "pay life equal to its mana value. If you do, put it onto the battlefield under your control. It's a Warlock in addition to its other types";
    }

    private LorcanWarlockCollectorReturnEffect(LorcanWarlockCollectorReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public LorcanWarlockCollectorReturnEffect copy() {
        return new LorcanWarlockCollectorReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        PayLifeCost cost = new PayLifeCost(card.getManaValue());
        if (!cost.canPay(source, source, source.getControllerId(), game) || !cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        game.addEffect(new AddCardSubTypeTargetEffect(SubType.WARLOCK, Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(card.getId(), card.getZoneChangeCounter(game) + 1)), source);
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        return true;
    }
}

