/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class LoreholdCommandEffect
extends OneShotEffect {
    LoreholdCommandEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 3 damage to any target. Target player gains 3 life";
    }

    private LoreholdCommandEffect(LoreholdCommandEffect effect) {
        super((OneShotEffect)effect);
    }

    public LoreholdCommandEffect copy() {
        return new LoreholdCommandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent targetPermanent;
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer != null) {
            targetPlayer.damage(3, source.getSourceId(), source, game);
        }
        if ((targetPermanent = game.getPermanent(source.getFirstTarget())) != null) {
            targetPermanent.damage(3, source.getSourceId(), source, game);
        }
        if ((player = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            player.gainLife(3, game, source);
        }
        return true;
    }
}

