/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LostInTheWoodsEffect
extends OneShotEffect {
    LostInTheWoodsEffect() {
        super(Outcome.PreventDamage);
        this.staticText = "reveal the top card of your library. If it's a Forest card, remove that creature from combat. Then put the revealed card on the bottom of your library";
    }

    private LostInTheWoodsEffect(LostInTheWoodsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject == null || controller == null) {
            return false;
        }
        if (controller.getLibrary().hasCards()) {
            Card card = controller.getLibrary().getFromTop(game);
            CardsImpl cards = new CardsImpl(card);
            controller.revealCards(sourceObject.getName(), (Cards)cards, game);
            if (card != null) {
                Permanent permanent;
                if (card.hasSubtype(SubType.FOREST, game) && (permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
                    permanent.removeFromCombat(game);
                }
                controller.moveCardToLibraryWithInfo(card, source, game, Zone.LIBRARY, false, true);
            }
        }
        return true;
    }

    public LostInTheWoodsEffect copy() {
        return new LostInTheWoodsEffect(this);
    }
}

