/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class LostInThoughtCantActivateAbilitiesEffect
extends ContinuousRuleModifyingEffectImpl {
    LostInThoughtCantActivateAbilitiesEffect() {
        super(Duration.WhileOnBattlefield, Outcome.UnboostCreature);
        this.staticText = ", and its activated abilities can't be activated";
    }

    private LostInThoughtCantActivateAbilitiesEffect(LostInThoughtCantActivateAbilitiesEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public LostInThoughtCantActivateAbilitiesEffect copy() {
        return new LostInThoughtCantActivateAbilitiesEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchanted;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && event.getSourceId().equals(enchantment.getAttachedTo()) && (enchanted = game.getPermanent(enchantment.getAttachedTo())) != null) {
            String key = source.getSourceId().toString() + enchantment.getZoneChangeCounter(game) + "_ignoreEffectForTurn" + game.getTurnNum() + enchanted.getControllerId();
            return game.getState().getValue(key) == null;
        }
        return false;
    }
}

